/******************************************************************************

  Copyright (C) 2010 [Hilscher Gesellschaft für Systemautomation mbH]

  This program can be used by everyone according to the netX Open Source
  Software license. The license agreement can be downloaded from
  http://www.industrialNETworX.com

 ******************************************************************************

  Last Modification:
    @version $Id: ProfibusMPI_Public.h 20224 2011-10-31 08:50:01Z AndreasB $

  Description:
    The header contains the public definition of task.
    It has to be included by another task to get access of task specific
    definition.

  Changes:
    Date        Author        Description
  ---------------------------------------------------------------------------
    2010-10-20  NC            File created.

******************************************************************************/
#ifndef __PROFIBUS_MPI_PUBLIC_H
#define __PROFIBUS_MPI_PUBLIC_H

#include "ProfibusDl_BusParameter.h"

#define MPI_STACK_SIZE 4096

/******************************************************************************
  Queue Name
    Use the queue name to identify the process queue of task.
******************************************************************************/
#define PROFIBUS_MPI_QUEUE_NAME           "QUE_PB_MPI"

/******************************************************************************
  Command numbers
******************************************************************************/
#define PROFIBUS_MPI_CMD_INIT_REQ                 0x00004300  /* Initialized/Reset MPI-Stack Request       */
#define PROFIBUS_MPI_CMD_INIT_CNF                 0x00004301  /* Initialized/Reset MPI-Stack Confirmation  */

/*#define PROFIBUS_MPI_CMD_RESET_REQ                0x00004302 obsolete command               */
/*#define PROFIBUS_MPI_CMD_RESET_CNF                0x00004303 use PROFIBUS_MPI_CMD_INIT_REQ  */

#define PROFIBUS_MPI_CMD_RW_TR_REQ                0x00004304  /* Transparent Command Request                */
#define PROFIBUS_MPI_CMD_RW_TR_CNF                0x00004305  /* Transparent Command Confirmation           */

#define PROFIBUS_MPI_CMD_RW_DB_REQ                0x00004306  /* Read Write Datablock Request               */
#define PROFIBUS_MPI_CMD_RW_DB_CNF                0x00004307  /* Read Write Datablock Confirmation          */

#define PROFIBUS_MPI_CMD_R_OP_REQ                 0x00004308  /* Read Operation status Request              */
#define PROFIBUS_MPI_CMD_R_OP_CNF                 0x00004309  /* Read Operation status Confirmation         */

#define PROFIBUS_MPI_CMD_RW_ME_REQ                0x0000430A  /* Read Write Memoryblock Request             */
#define PROFIBUS_MPI_CMD_RW_ME_CNF                0x0000430B  /* Read Write Memoryblock Confirmation        */

#define PROFIBUS_MPI_CMD_RW_IO_REQ                0x0000430C  /* Read Write IO Request                      */
#define PROFIBUS_MPI_CMD_RW_IO_CNF                0x0000430D  /* Read Write IO Confirmation                 */

#define PROFIBUS_MPI_CMD_RW_CN_REQ                0x0000430E  /* Read Write Counter Request                 */
#define PROFIBUS_MPI_CMD_RW_CN_CNF                0x0000430F  /* Read Write Counter Confirmation            */

#define PROFIBUS_MPI_CMD_RW_TI_REQ                0x00004310  /* Read Write Timer Request                   */
#define PROFIBUS_MPI_CMD_RW_TI_CNF                0x00004311  /* Read Write Timer Confirmation              */

#define PROFIBUS_MPI_CMD_DC_REQ                   0x00004312  /* Disconnect Request                         */
#define PROFIBUS_MPI_CMD_DC_CNF                   0x00004313  /* Disconnect Confirmation                    */

#define PROFIBUS_MPI_CMD_DC_ALL_REQ               0x00004314  /* Disconnect all open handler Request        */
#define PROFIBUS_MPI_CMD_DC_ALL_CNF               0x00004315  /* Disconnect all open handler Confirmation   */

#define PROFIBUS_MPI_CMD_SET_BUS_PARAM_REQ        0x00004316  /* Set Busparameter Request       */
#define PROFIBUS_MPI_CMD_SET_BUS_PARAM_CNF        0x00004317  /* Set Busparameter Confirmation  */

/*#define PROFIBUS_MPI_CMD_WARMSTART_REQ            0x00004318  obsolete command                        */
/*#define PROFIBUS_MPI_CMD_WARMSTART_CNF            0x00004319  use PROFIBUS_MPI_CMD_SET_BUS_PARAM_REQ  */

#define PROFIBUS_MPI_CMD_SOCKET_CLOSE_REQ         0x0000431A  /* Close all sockets Request      */
#define PROFIBUS_MPI_CMD_SOCKET_CLOSE_CNF         0x0000431B  /* Close all sockets Confirmation */

/*#define PROFIBUS_MPI_CMD_SET_CONFIG_REQ           0x0000431C  obsolete command                        */
/*#define PROFIBUS_MPI_CMD_SET_CONFIG_CNF           0x0000431D  use PROFIBUS_MPI_CMD_SET_BUS_PARAM_REQ  */

#define PROFIBUS_MPI_CMD_MULTIPLE_READ_REQ        0x0000431E  /* Multiple read Request        */
#define PROFIBUS_MPI_CMD_MULTIPLE_READ_CNF        0x0000431F  /* Multiple read Confirmation   */

#define PROFIBUS_MPI_CMD_MULTIPLE_WRITE_REQ       0x00004320  /* Multiple write Request       */
#define PROFIBUS_MPI_CMD_MULTIPLE_WRITE_CNF       0x00004321  /* Multiple write Confirmation  */

#define PROFIBUS_MPI_CMD_GET_INFO_REQ             0x00004322  /* Get Status information of the MPI Task Request       */
#define PROFIBUS_MPI_CMD_GET_INFO_CNF             0x00004323  /* Get Status information of the MPI Task Confirmation  */

#define PROFIBUS_MPI_CMD_STARTSTOP_REQ            0x00004324  /* Start/Stop the bus communication Request       */
#define PROFIBUS_MPI_CMD_STARTSTOP_CNF            0x00004325  /* Start/Stop the bus communication Confirmation  */

//#define PROFIBUS_MPI_REGISTER_REQ                 0x00004326  /* Register for Indications Request */
//#define PROFIBUS_MPI_REGISTER_CNF                 0x00004327  /* Register for Indications Confirmation */

//#define PROFIBUS_MPI_CMD_AUTO_BAUD_COMPLETE_IND   0x00004328  /* Auto Baud detection complete Indication */
//#define PROFIBUS_MPI_CMD_AUTO_BAUD_COMPLETE_RES   0x00004329  /* Auto Baud detection complete Response */


/******************************************************************************
  Stack relevant Defines:
******************************************************************************/
#define PROFIBUS_MPI_MAX_CONNECTION_HANDLER     127
#define PROFIBUS_MPI_MAX_BUS_ADDR               126
#define PROFIBUS_MPI_RW_MAX_SOCKET_NUM           63

#define PROFIBUS_MPI_RW_FUNCTION_READ             1
#define PROFIBUS_MPI_RW_FUNCTION_WRITE            2

#define PROFIBUS_MPI_RW_DATA_TYPE_BYTE            0
#define PROFIBUS_MPI_RW_DATA_TYPE_BIT             1

/******************************************************************************
  Stack relevant structures:
******************************************************************************/
typedef __TLR_PACKED_PRE struct  PROFIBUS_MPI_EXT_STATUS_Ttag {
  void* vpDummy;
}__TLR_PACKED_POST PROFIBUS_MPI_EXT_STATUS_T;

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_RW_DB_REQ
    - PROFIBUS_MPI_CMD_RW_DB_CNF
******************************************************************************/
#define PROFIBUS_MPI_RW_DB_MAX_DATA_SIZE     222

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_RW_DB_Ttag {
  TLR_UINT32  ulRemAddr;
  TLR_UINT32  ulDataType;
  TLR_UINT32  ulDBNumber;
  TLR_UINT32  ulOffset;
  TLR_UINT32  ulDataCnt;
  TLR_UINT32  ulBitOffset;
  TLR_UINT32  ulFunction;
  TLR_UINT8   abData[PROFIBUS_MPI_RW_DB_MAX_DATA_SIZE];
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_RW_DB_T;

typedef struct PROFIBUS_MPI_PACKET_RW_DB_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_DB_T tData;

}PROFIBUS_MPI_PACKET_RW_DB_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_RW_DB_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_DB_T tData;

}PROFIBUS_MPI_PACKET_RW_DB_CNF_T;

#define  PROFIBUS_MPI_MIN_RW_DB_PACK_SIZE (7*sizeof(TLR_UINT32))

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_RW_ME_REQ
    - PROFIBUS_MPI_CMD_RW_ME_CNF
******************************************************************************/
#define PROFIBUS_MPI_RW_ME_MAX_DATA_SIZE     222

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_RW_ME_Ttag {
  TLR_UINT32  ulRemAddr;
  TLR_UINT32  ulDataType;
  TLR_UINT32  ulMerkerAddr;
  TLR_UINT32  ulReserved2;
  TLR_UINT32  ulDataCnt;
  TLR_UINT32  ulBitOffset;
  TLR_UINT32  ulFunction;
  TLR_UINT8   abData[PROFIBUS_MPI_RW_ME_MAX_DATA_SIZE];
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_RW_ME_T;

typedef struct PROFIBUS_MPI_PACKET_RW_ME_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_ME_T tData;

}PROFIBUS_MPI_PACKET_RW_ME_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_RW_ME_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_ME_T tData;

}PROFIBUS_MPI_PACKET_RW_ME_CNF_T;

#define  PROFIBUS_MPI_MIN_RW_ME_PACK_SIZE (7*sizeof(TLR_UINT32))

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_RW_IO_REQ
    - PROFIBUS_MPI_CMD_RW_IO_CNF
******************************************************************************/
#define PROFIBUS_MPI_RW_IO_MAX_DATA_SIZE     222

#define PROFIBUS_MPI_RW_IO_AREA_INPUT             0
#define PROFIBUS_MPI_RW_IO_AREA_OUTPUT            1

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_RW_IO_Ttag
{
  TLR_UINT32  ulRemAddr;
  TLR_UINT32  ulIOArea;
  TLR_UINT32  ulIOAddr;
  TLR_UINT32  ulDataType;
  TLR_UINT32  ulDataCnt;
  TLR_UINT32  ulBitOffset;
  TLR_UINT32  ulFunction;
  TLR_UINT8   abData[PROFIBUS_MPI_RW_IO_MAX_DATA_SIZE];
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_RW_IO_T;

typedef struct PROFIBUS_MPI_PACKET_RW_IO_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_IO_T tData;

}PROFIBUS_MPI_PACKET_RW_IO_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_RW_IO_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_IO_T tData;

}PROFIBUS_MPI_PACKET_RW_IO_CNF_T;

#define  PROFIBUS_MPI_MIN_RW_IO_PACK_SIZE (7*sizeof(TLR_UINT32))

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_RW_CN_REQ
    - PROFIBUS_MPI_CMD_RW_CN_CNF
******************************************************************************/
#define PROFIBUS_MPI_RW_CN_MAX_DATA_SIZE     111

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_RW_CN_Ttag
{
  TLR_UINT32  ulRemAddr;
  TLR_UINT32  ulReserved1;
  TLR_UINT32  ulCounterAddr;
  TLR_UINT32  ulReserved2;
  TLR_UINT32  ulDataCnt;
  TLR_UINT32  ulReserved3;
  TLR_UINT32  ulFunction;
  TLR_UINT16  ausData[PROFIBUS_MPI_RW_CN_MAX_DATA_SIZE];
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_RW_CN_T;

typedef struct PROFIBUS_MPI_PACKET_RW_CN_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_CN_T tData;

}PROFIBUS_MPI_PACKET_RW_CN_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_RW_CN_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_CN_T tData;

}PROFIBUS_MPI_PACKET_RW_CN_CNF_T;

#define  PROFIBUS_MPI_MIN_RW_CN_PACK_SIZE (7*sizeof(TLR_UINT32))

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_RW_TI_REQ
    - PROFIBUS_MPI_CMD_RW_TI_CNF
******************************************************************************/
#define PROFIBUS_MPI_RW_TI_MAX_DATA_SIZE     111

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_RW_TI_Ttag
{
  TLR_UINT32  ulRemAddr;
  TLR_UINT32  ulReserved1;
  TLR_UINT32  ulTimerAddr;
  TLR_UINT32  ulReserved2;
  TLR_UINT32  ulDataCnt;
  TLR_UINT32  ulReserved3;
  TLR_UINT32  ulFunction;
  TLR_UINT16  ausData[PROFIBUS_MPI_RW_TI_MAX_DATA_SIZE];
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_RW_TI_T;

typedef struct PROFIBUS_MPI_PACKET_RW_TI_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_TI_T tData;

}PROFIBUS_MPI_PACKET_RW_TI_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_RW_TI_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  PROFIBUS_MPI_DATA_MPI_RW_TI_T tData;

}PROFIBUS_MPI_PACKET_RW_TI_CNF_T;

#define  PROFIBUS_MPI_MIN_RW_TI_PACK_SIZE (7*sizeof(TLR_UINT32))

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_R_OP_REQ
    - PROFIBUS_MPI_CMD_R_OP_CNF
******************************************************************************/
#define OPSTATE_STOP          0  /* CPU state stoped    */
#define OPSTATE_START         1  /* CPU state start up  */
#define OPSTATE_RUN           2  /* CPU state Run       */
#define OPSTATE_UNKNOWN       3  /* CPU state unknown   */

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_OP_Ttag
{
  TLR_UINT32  ulRemAddr;
  TLR_UINT32  ulReserved1;
  TLR_UINT32  ulReserved2;
  TLR_UINT32  ulReserved3;
  TLR_UINT32  ulReserved4;
  TLR_UINT32  ulReserved5;
  TLR_UINT32  ulReserved7;
  TLR_UINT16  usOpState;
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_OP_T;

typedef struct PROFIBUS_MPI_PACKET_READ_OP_REQ_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  PROFIBUS_MPI_DATA_MPI_OP_T  tData;

}PROFIBUS_MPI_PACKET_READ_OP_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_READ_OP_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  PROFIBUS_MPI_DATA_MPI_OP_T  tData;

}PROFIBUS_MPI_PACKET_READ_OP_CNF_T;

#define  PROFIBUS_MPI_MIN_READ_OP_PACK_SIZE (7*sizeof(TLR_UINT32))

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_RW_TR_REQ
    - PROFIBUS_MPI_CMD_RW_TR_CNF
******************************************************************************/
#define PROFIBUS_MPI_TR_MAX_DATA_SIZE     222

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_TR_Ttag
{
  TLR_UINT32  ulRemAddr;
  TLR_UINT32  ulReserved1;
  TLR_UINT32  ulReserved2;
  TLR_UINT32  ulReserved3;
  TLR_UINT32  ulDataCnt;
  TLR_UINT32  ulReserved5;
  TLR_UINT32  ulReserved6;
  TLR_UINT8   abData[PROFIBUS_MPI_TR_MAX_DATA_SIZE];
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_TR_T;

typedef struct PROFIBUS_MPI_PACKET_TRANSPARENT_REQ_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  PROFIBUS_MPI_DATA_MPI_TR_T  tData;

}PROFIBUS_MPI_PACKET_TRANSPARENT_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_TRANSPARENT_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  PROFIBUS_MPI_DATA_MPI_TR_T  tData;

}PROFIBUS_MPI_PACKET_TRANSPARENT_CNF_T;

#define  PROFIBUS_MPI_MIN_TR_PACK_SIZE (7*sizeof(TLR_UINT32))

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_INIT_REQ
    - PROFIBUS_MPI_CMD_INIT_CNF
******************************************************************************/
typedef TLR_EMPTY_PACKET_T PROFIBUS_MPI_PACKET_INIT_REQ_T;
typedef TLR_EMPTY_PACKET_T PROFIBUS_MPI_PACKET_INIT_CNF_T;

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_DC_ALL_REQ
    - PROFIBUS_MPI_CMD_DC_ALL_CNF
******************************************************************************/
typedef TLR_EMPTY_PACKET_T PROFIBUS_MPI_PACKET_DC_ALL_REQ_T;
typedef TLR_EMPTY_PACKET_T PROFIBUS_MPI_PACKET_DC_ALL_CNF_T;

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_DC_REQ
    - PROFIBUS_MPI_CMD_DC_CNF
******************************************************************************/
typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MPI_DC_Ttag
{
  TLR_UINT32  ulRemAddr;
} __TLR_PACKED_POST PROFIBUS_MPI_DATA_MPI_DC_T;

typedef struct PROFIBUS_MPI_PACKET_MPI_DC_REQ_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  PROFIBUS_MPI_DATA_MPI_DC_T  tData;
} PROFIBUS_MPI_PACKET_MPI_DC_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_MPI_DC_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  PROFIBUS_MPI_DATA_MPI_DC_T  tData;
} PROFIBUS_MPI_PACKET_MPI_DC_CNF_T;

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_SOCKET_CLOSE_REQ
    - PROFIBUS_MPI_CMD_SOCKET_CLOSE_CNF
******************************************************************************/
typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_SOCKET_CLOSE_REQ_Ttag
{
  TLR_UINT32 ulSocket;
} __TLR_PACKED_POST PROFIBUS_MPI_SOCKET_CLOSE_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_CLOSE_SOCKET_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  PROFIBUS_MPI_SOCKET_CLOSE_REQ_T tData;
} PROFIBUS_MPI_PACKET_CLOSE_SOCKET_REQ_T;

typedef TLR_EMPTY_PACKET_T PROFIBUS_MPI_PACKET_CLOSE_SOCKET_CNF_T;

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_SET_BUS_PARAM_REQ
    - PROFIBUS_MPI_CMD_SET_BUS_PARAM_CNF
******************************************************************************/
typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_SET_BUS_PARAMETER_DATA_Ttag
{
  PROFIBUS_DL_BUS_PARAMETER_SET_T tBusParameter;

}__TLR_PACKED_POST PROFIBUS_MPI_SET_BUS_PARAMETER_DATA_T;

typedef struct PROFIBUS_MPI_PACKET_SET_BUS_PARAMETER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  PROFIBUS_MPI_SET_BUS_PARAMETER_DATA_T tData;

} PROFIBUS_MPI_PACKET_SET_BUS_PARAMETER_REQ_T;

typedef struct PROFIBUS_MPI_PACKET_SET_BUS_PARAMETER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  PROFIBUS_MPI_SET_BUS_PARAMETER_DATA_T tData;

} PROFIBUS_MPI_PACKET_SET_BUS_PARAMETER_CNF_T;

#define SET_BUS_PARAMETER_REQ_MIN_LEN  19

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_GET_INFO_REQ
    - PROFIBUS_MPI_CMD_GET_INFO_CNF
******************************************************************************/
typedef TLR_EMPTY_PACKET_T  PROFIBUS_MPI_PACKET_GET_INFO_REQ_T;

#define PROFIBUS_MPI_INFO_BUS_STATUS_UNKNOWN                0x00000000
/*#define PROFIBUS_MPI_INFO_BUS_STATUS_INIT_IN_PROGRESS       0x00000001 obsolete flag */
#define PROFIBUS_MPI_INFO_BUS_STATUS_CONFIGURED             0x00000002
#define PROFIBUS_MPI_INFO_BUS_STATUS_AUTO_BAUD_ACTIVE       0x00000004
#define PROFIBUS_MPI_INFO_BUS_STATUS_WAIT_FOR_BUS_PARAM_IND 0x00000008
#define PROFIBUS_MPI_INFO_BUS_STATUS_RUNNING                0x00000010
#define PROFIBUS_MPI_INFO_BUS_STATUS_LONELY_NETWORK         0x00000020

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_GET_INFO_CNF_DATA_Ttag
{
  TLR_UINT32  ulBusStatusFlags;
  TLR_UINT32  ulOpenConnections;
  TLR_UINT32  aulReserved[14];

}__TLR_PACKED_POST PROFIBUS_MPI_GET_INFO_DATA_T;

typedef struct PROFIBUS_MPI_PACKET_GET_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  PROFIBUS_MPI_GET_INFO_DATA_T          tData;

} PROFIBUS_MPI_PACKET_GET_INFO_CNF_T;

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_MULTIPLE_READ_REQ
    - PROFIBUS_MPI_CMD_MULTIPLE_READ_CNF

  Request:
  /-------------------------------------------\
  | Addr| Amount | Res | ReadReq |[ReadReq...]|
  \-------------------------------------------/

  Response:
  /------------------------------------------------------------\
  | Addr| Amount | Res | ReadCnf |[ReadCnf...]| Data |[Data...]|
  \------------------------------------------------------------/

******************************************************************************/
#define PROFIBUS_MPI_AREA_COUNTER       0x01
#define PROFIBUS_MPI_AREA_TIMER         0x02
#define PROFIBUS_MPI_AREA_INPUT         0x03
#define PROFIBUS_MPI_AREA_OUTPUT        0x04
#define PROFIBUS_MPI_AREA_MARKER        0x05
#define PROFIBUS_MPI_AREA_DATA          0x06

#define PROFIBUS_MPI_TYPE_DEFAULT       0x00
#define PROFIBUS_MPI_TYPE_BOOL          0x01

#define MAX_MULTIPLE_READ_CMD              6
#define MAX_MULTIPLE_READ_SIZE           222

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_ORDER_MULTIPLE_READ_REQ_Ttag
{
  TLR_UINT8  bArea;           /* Area */
  TLR_UINT8  bDataType;       /* Data type */
  TLR_UINT16 usNumOfElements; /* Number of elements (set to 1 if bDataType == S7_TYPE_BOOL) */
  TLR_UINT16 usDBNum;         /* DB Number (set to 0 if bArea != S7_AREA_DATA) */
  TLR_UINT16 usOffset;        /* S7 byte offset */
  TLR_UINT8  bBitOffset;      /* S7 bit offset (0 to 7) */
  TLR_UINT8  abReserved[7];   /* Reserved for confirmation data */

}__TLR_PACKED_POST PROFIBUS_MPI_ORDER_MULTIPLE_READ_REQ_T;

#define PROFIBUS_MPI_ACCESSRESULT_NO_ERROR              0xFF
#define PROFIBUS_MPI_ACCESSRESULT_HARDWARE_ERROR        0x01
#define PROFIBUS_MPI_ACCESSRESULT_INVALID_CODE          0x03
#define PROFIBUS_MPI_ACCESSRESULT_INVALID_ADDRESS       0x05
#define PROFIBUS_MPI_ACCESSRESULT_UNKNOWN_DATA_TYPE     0x06
#define PROFIBUS_MPI_ACCESSRESULT_PDU_ERROR             0x07
#define PROFIBUS_MPI_ACCESSRESULT_OBJECT_NOT_EXIST      0x0A

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_ORDER_MULTIPLE_READ_CNF_Ttag
{
  TLR_UINT8  bArea;           /* Area */
  TLR_UINT8  bDataType;       /* Data type */
  TLR_UINT16 usNumOfElements; /* Number of elements (set to 1 if bDataType == S7_TYPE_BOOL) */
  TLR_UINT16 usDBNum;         /* DB Number (set to 0 if bArea != S7_AREA_DATA) */
  TLR_UINT16 usOffset;        /* S7 byte offset */
  TLR_UINT8  bBitOffset;      /* S7 bit offset (0 to 7) */
  TLR_UINT8  abReserved[2];   /* Reserved for future use */
  TLR_UINT8  bAccessResult;   /* Access result */
  TLR_UINT16 usDataOffset;    /* Data offset of abData[] */
  TLR_UINT16 usDataLen;       /* Length of data */
}__TLR_PACKED_POST PROFIBUS_MPI_ORDER_MULTIPLE_READ_CNF_T;


typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MULTIPLE_READ_REQ_Ttag
{
  TLR_UINT8 bRemAddr;
  TLR_UINT8 bNumOfRequests;
  TLR_UINT8 abReserved[2];
  PROFIBUS_MPI_ORDER_MULTIPLE_READ_REQ_T  atRequests[MAX_MULTIPLE_READ_CMD];

}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MULTIPLE_READ_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MULTIPLE_READ_CNF_Ttag
{
  TLR_UINT8 bRemAddr;
  TLR_UINT8 bNumOfResponses;
  TLR_UINT8 abReserved[2];
  union __TLR_PACKED_PRE{
    PROFIBUS_MPI_ORDER_MULTIPLE_READ_CNF_T  atResponses[MAX_MULTIPLE_READ_CMD];
    TLR_UINT8 abData[MAX_MULTIPLE_READ_CMD \
                     * sizeof(PROFIBUS_MPI_ORDER_MULTIPLE_READ_REQ_T) \
                     + MAX_MULTIPLE_READ_SIZE];
  }__TLR_PACKED_POST;
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MULTIPLE_READ_CNF_T;


typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_PACKET_MULTIPLE_READ_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  PROFIBUS_MPI_DATA_MULTIPLE_READ_REQ_T tData;

}__TLR_PACKED_POST PROFIBUS_MPI_PACKET_MULTIPLE_READ_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_PACKET_MULTIPLE_READ_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  PROFIBUS_MPI_DATA_MULTIPLE_READ_CNF_T tData;

}__TLR_PACKED_POST PROFIBUS_MPI_PACKET_MULTIPLE_READ_CNF_T;

#define PROFIBUS_MPI_PACKET_MIN_MULTIPLE_READ_LEN   (4 + 16)

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_MULTIPLE_WRITE_REQ
    - PROFIBUS_MPI_CMD_MULTIPLE_WRITE_CNF

  Request:
  /--------------------------------------------------------------\
  | Addr| Amount | Res | WriteReq |[WriteReq...]| Data |[Data...]|
  \--------------------------------------------------------------/

  Response:
  /--------------------------------------------------------------\
  | Addr| Amount | Res | WriteCnf |[WriteCnf...]| Data |[Data...]|
  \--------------------------------------------------------------/

******************************************************************************/
#define MAX_MULTIPLE_WRITE_CMD      6
#define MAX_MULTIPLE_WRITE_SIZE   212

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_ORDER_MULTIPLE_WRITE_REQ_Ttag
{
  TLR_UINT8  bArea;           /* Area */
  TLR_UINT8  bDataType;       /* Data type */
  TLR_UINT16 usNumOfElements; /* Number of elements (set to 1 if bDataType == S7_TYPE_BOOL) */
  TLR_UINT16 usDBNum;         /* DB Number (set to 0 if bArea != S7_AREA_DATA) */
  TLR_UINT16 usOffset;        /* S7 byte offset */
  TLR_UINT8  bBitOffset;      /* S7 bit offset (0 to 7) */
  TLR_UINT8  abReserved[3];   /* Reserved for future use */
  TLR_UINT16 usDataOffset;    /* Data offset of abData[] */
  TLR_UINT16 usDataLen;       /* Length of data */

}__TLR_PACKED_POST PROFIBUS_MPI_ORDER_MULTIPLE_WRITE_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_ORDER_MULTIPLE_WRITE_CNF_Ttag
{
  TLR_UINT8  bArea;           /* Area */
  TLR_UINT8  bDataType;       /* Data type */
  TLR_UINT16 usNumOfElements; /* Number of elements (set to 1 if bDataType == S7_TYPE_BOOL) */
  TLR_UINT16 usDBNum;         /* DB Number (set to 0 if bArea != S7_AREA_DATA) */
  TLR_UINT16 usOffset;        /* S7 byte offset */
  TLR_UINT8  bBitOffset;      /* S7 bit offset (0 to 7) */
  TLR_UINT8  abReserved[2];   /* Reserved for future use */
  TLR_UINT8  bAccessResult;   /* Access result */
  TLR_UINT8  abReserved2[4];   /* Reserved for future use */

}__TLR_PACKED_POST PROFIBUS_MPI_ORDER_MULTIPLE_WRITE_CNF_T;


typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MULTIPLE_WRITE_REQ_Ttag
{
  TLR_UINT8 bRemAddr;
  TLR_UINT8 bNumOfRequests;
  TLR_UINT8 abReserved[2];
  union __TLR_PACKED_PRE{
    PROFIBUS_MPI_ORDER_MULTIPLE_WRITE_REQ_T atRequests[MAX_MULTIPLE_WRITE_CMD];
    TLR_UINT8 abData[MAX_MULTIPLE_WRITE_CMD \
                     * sizeof(PROFIBUS_MPI_ORDER_MULTIPLE_WRITE_REQ_T) \
                     + MAX_MULTIPLE_WRITE_SIZE];
  }__TLR_PACKED_POST;
}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MULTIPLE_WRITE_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_DATA_MULTIPLE_WRITE_CNF_Ttag
{
  TLR_UINT8 bRemAddr;
  TLR_UINT8 bNumOfResponses;
  TLR_UINT8 abReserved[2];
  PROFIBUS_MPI_ORDER_MULTIPLE_WRITE_CNF_T atResponses[MAX_MULTIPLE_WRITE_CMD];

}__TLR_PACKED_POST PROFIBUS_MPI_DATA_MULTIPLE_WRITE_CNF_T;


typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_PACKET_MULTIPLE_WRITE_REQ_Ttag
{
    TLR_PACKET_HEADER_T                     tHead;
    PROFIBUS_MPI_DATA_MULTIPLE_WRITE_REQ_T  tData;

}__TLR_PACKED_POST PROFIBUS_MPI_PACKET_MULTIPLE_WRITE_REQ_T;

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_PACKET_MULTIPLE_WRITE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  PROFIBUS_MPI_DATA_MULTIPLE_WRITE_CNF_T  tData;

}__TLR_PACKED_POST PROFIBUS_MPI_PACKET_MULTIPLE_WRITE_CNF_T;

#define PROFIBUS_MPI_PACKET_MIN_MULTIPLE_WRITE_LEN   (4 + 16)

/******************************************************************************
  Structure and defines for command numbers:
    - PROFIBUS_MPI_CMD_STARTSTOP_REQ
    - PROFIBUS_MPI_CMD_STARTSTOP_CNF
******************************************************************************/
#define PROFIBUS_MPI_STARTSTOP_STOP     0x00000000
#define PROFIBUS_MPI_STARTSTOP_START    0x00000001

typedef __TLR_PACKED_PRE struct PROFIBUS_MPI_STARTSTOP_Ttag
{
  TLR_UINT32  ulMode;

}__TLR_PACKED_POST PROFIBUS_MPI_STARTSTOP_T;

typedef struct PROFIBUS_MPI_PACKET_STARTSTOP_REQ_Ttag
{
  TLR_PACKET_HEADER_T       tHead;
  PROFIBUS_MPI_STARTSTOP_T  tData;

} PROFIBUS_MPI_PACKET_STARTSTOP_REQ_T;

typedef PROFIBUS_MPI_PACKET_STARTSTOP_REQ_T  \
    PROFIBUS_MPI_PACKET_STARTSTOP_CNF_T;


#endif /* __PROFIBUS_MPI_PUBLIC_H */

/********************************************************************************************/
/******************* End of file ************************************************************/
/********************************************************************************************/
